# Generated by Django 4.0.3 on 2022-04-11 18:50

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Menu',
            fields=[
                ('id', models.BigAutoField(auto_created=True,
                                           primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=40)),
            ],
            options={
                'ordering': ('pk',),
            },
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.BigAutoField(auto_created=True,
                                           primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=256)),
                ('slug', models.SlugField(
                    help_text='e.g: if the slug is "privacy-policy" then the page URL would look like "https://domain.com/privacy-policy"', max_length=256, unique=True)),
                ('content', models.TextField(blank=True, null=True)),
                ('status', models.IntegerField(choices=[
                 (0, 'Published'), (1, 'Unpublished'), (2, 'Draft')], default=2)),
                ('keywords', models.CharField(
                    blank=True, help_text='Keywords for SEO, e.g: keyword1, keyword2, keyword3...', max_length=512, null=True)),
                ('description', models.TextField(blank=True,
                                                 help_text='A small description for SEO.', null=True)),
                ('head_code', models.TextField(
                    blank=True, help_text='A code that will be injected in "head" tag, e.g: Facebook Pixel, Google Analytics code, ...etc', null=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='MenuItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True,
                                           primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=40)),
                ('item_type', models.IntegerField(
                    choices=[(0, 'Link'), (1, 'Page')], default=0)),
                ('url', models.CharField(blank=True, help_text='Relative URL e.g: "/games" or a full URL "https://domain.com/privacy-policy".',
                                         max_length=256, null=True, verbose_name='URL')),
                ('target', models.IntegerField(choices=[
                 (0, '_self'), (1, '_blank'), (2, '_parent'), (3, '_top')], default=0)),
                ('css_class', models.CharField(
                    blank=True, max_length=256, null=True)),
                ('order', models.IntegerField(db_index=True, default=0)),
                ('menu', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE, related_name='items', to='pages.menu')),
                ('page', models.ForeignKey(blank=True, null=True,
                                           on_delete=django.db.models.deletion.CASCADE, to='pages.page')),
            ],
            options={
                'ordering': ('order',),
            },
        ),
    ]
